--
-- Table structure for table `supplier_invoice`
--

CREATE TABLE `supplier_invoice` (
  `id` int(11) NOT NULL,
  `gl_account` varchar(100) NOT NULL,
  `date_created` varchar(30) NOT NULL,
  `name` varchar(200) NOT NULL,
  `inv_date` varchar(30) NOT NULL,
  `inv_number` varchar(100) NOT NULL,
  `currency` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `quantity` varchar(100) NOT NULL,
  `price` varchar(100) NOT NULL,
  `discount` varchar(100) NOT NULL,
  `total_amount` varchar(100) NOT NULL,
  `active` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `supplier_invoice`
--

INSERT INTO `supplier_invoice` (`id`, `gl_account`, `date_created`, `name`, `inv_date`, `inv_number`, `currency`, `description`, `quantity`, `price`, `discount`, `total_amount`, `active`) VALUES
(15, '', '2022-12-29 03:08:35pm', 'DANIEL', '2022-12-08', 'INV0001', 'USD', 'eee', '222', '2', '22', '346.32', 1),
(16, '', '2022-12-29 03:14:01pm', 'DANIEL', '2022-12-13', 'INV0002', 'USD', 'rr', '33', '3', '33', '66.33', 1),
(17, 'Income', '2023-01-03 03:13:00pm', 'DANIEL', '2023-01-03', 'INV0004', 'USD', 'jj', '4', '1', '1', '3.96', 1),
(20, 'Income', '2023-01-04 11:33:21am', 'DANIEL', '2023-01-04', 'INV0005', 'USD', '100 mari', '100', '1', '2', '98', 1);

-- --------------------------------------------------------

--
-- Table structure for table `supplier_receipt`
--

CREATE TABLE `supplier_receipt` (
  `id` int(11) NOT NULL,
  `date_created` varchar(30) NOT NULL,
  `gl_account` varchar(100) NOT NULL,
  `name` varchar(200) NOT NULL,
  `rec_date` varchar(30) NOT NULL,
  `rec_number` varchar(100) NOT NULL,
  `inv_number` varchar(100) NOT NULL,
  `currency` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `quantity` varchar(100) NOT NULL,
  `price` varchar(100) NOT NULL,
  `discount` varchar(100) NOT NULL,
  `total_amount` varchar(100) NOT NULL,
  `active` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `supplier_receipt`
--

INSERT INTO `supplier_receipt` (`id`, `date_created`, `gl_account`, `name`, `rec_date`, `rec_number`, `inv_number`, `currency`, `description`, `quantity`, `price`, `discount`, `total_amount`, `active`) VALUES
(7, '2022-12-29 03:14:55pm', '', 'DANIEL', '2022-12-20', 'REC0001', 'INV0001', 'USD', 'GHGH', '128', '2', '10', '230.4', 1),
(8, '2023-01-04 11:44:55am', 'Income', 'DANIEL', '2023-01-09', 'REC0002', 'INV0005', 'USD', '1000 mari', '100', '2', '2', '196', 1);

-- --------------------------------------------------------

--
-- Table structure for table `supplier_statement`
--

CREATE TABLE `supplier_statement` (
  `id` int(11) NOT NULL,
  `gl_account` varchar(100) NOT NULL,
  `supplier` varchar(200) NOT NULL,
  `reference` varchar(200) NOT NULL,
  `description` varchar(200) NOT NULL,
  `currency` varchar(100) NOT NULL,
  `debit` varchar(100) NOT NULL,
  `credit` varchar(100) NOT NULL,
  `date` varchar(30) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `supplier_statement`
--

INSERT INTO `supplier_statement` (`id`, `gl_account`, `supplier`, `reference`, `description`, `currency`, `debit`, `credit`, `date`) VALUES
(6, '', 'DANIEL', 'INV0001', 'eee', 'USD', '0', '346.32', '2022-12-08'),
(7, '', 'DANIEL', 'INV0002', 'rr', 'USD', '0', '66.33', '2022-12-13'),
(8, '', 'DANIEL', 'REC0003', 'GHGH', 'USD', '230.4', '0', '2022-12-20'),
(12, 'Income', 'DANIEL', 'INV0004', '100 mari', 'USD', '0', '98', '2023-01-04'),
(13, 'Income', 'DANIEL', 'REC0005', '1000 mari', 'USD', '196', '0', '2023-01-09');

-- --------------------------------------------------------

--
-- Table structure for table `teacher_subjects`
--

CREATE TABLE `teacher_subjects` (
  `id` int(11) NOT NULL,
  `session_id` int(11) DEFAULT NULL,
  `class_section_id` int(11) DEFAULT NULL,
  `subject_id` int(11) DEFAULT NULL,
  `teacher_id` int(11) DEFAULT NULL,
  `description` varchar(100) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `teacher_subjects`
--

INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES
(1, 18, 2, 2, 2, NULL, 'no', '2022-09-21 05:18:18', ''),
(2, 18, 2, 0, 0, NULL, 'no', '2022-09-21 05:18:18', ''),
(3, 18, 9, 5, 3, NULL, 'no', '2022-11-24 04:32:25', '');

-- --------------------------------------------------------

--
-- Table structure for table `teams`
--

CREATE TABLE `teams` (
  `id` int(11) NOT NULL,
  `date_captured` varchar(50) NOT NULL,
  `team_name` varchar(200) NOT NULL,
  `sportcode` varchar(200) NOT NULL,
  `coachname` varchar(200) NOT NULL,
  `venue` varchar(200) NOT NULL,
  `description` varchar(200) NOT NULL,
  `active` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `teams`
--

INSERT INTO `teams` (`id`, `date_captured`, `team_name`, `sportcode`, `coachname`, `venue`, `description`, `active`) VALUES
(1, '2022-11-10 01:58:03pm', 'house 1', 'soc22', 'daniel', 'harare', 'news', 1);

-- --------------------------------------------------------

--
-- Table structure for table `timetables`
--

CREATE TABLE `timetables` (
  `id` int(11) NOT NULL,
  `teacher_subject_id` int(20) DEFAULT NULL,
  `day_name` varchar(50) DEFAULT NULL,
  `start_time` varchar(50) DEFAULT NULL,
  `end_time` varchar(50) DEFAULT NULL,
  `room_no` varchar(50) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `timetables`
--

INSERT INTO `timetables` (`id`, `teacher_subject_id`, `day_name`, `start_time`, `end_time`, `room_no`, `is_active`, `created_at`, `updated_at`) VALUES
(1, 3, 'Monday', '08:00 AM', '08:30 AM', '', 'no', '2022-11-24 05:18:46', ''),
(2, 3, 'Tuesday', '10:00 AM', '10:30 PM', '', 'no', '2022-11-24 05:18:46', ''),
(3, 3, 'Wednesday', '02:00 PM', '02:30 AM', '', 'no', '2022-11-24 05:18:46', ''),
(4, 3, 'Thursday', '09:00 AM', '09:30 AM', '', 'no', '2022-11-24 05:18:46', ''),
(5, 3, 'Friday', '10:00 AM', '10:30 AM', '', 'no', '2022-11-24 05:18:46', ''),
(6, 3, 'Saturday', '', '', '', 'no', '2022-11-24 05:18:46', ''),
(7, 3, 'Sunday', '', '', '', 'no', '2022-11-24 05:18:46', '');

-- --------------------------------------------------------

--
-- Table structure for table `transport_route`
--

CREATE TABLE `transport_route` (
  `id` int(11) NOT NULL,
  `route_title` varchar(100) DEFAULT NULL,
  `no_of_vehicle` int(11) DEFAULT NULL,
  `fare` float(10,2) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `transport_route`
--

INSERT INTO `transport_route` (`id`, `route_title`, `no_of_vehicle`, `fare`, `note`, `is_active`, `created_at`, `updated_at`) VALUES
(1, 'Hrare', NULL, 50.00, NULL, 'no', '2022-10-20 16:43:41', ''),
(3, 'Glenorah', NULL, 30.00, NULL, 'no', '2022-11-24 05:58:43', ''),
(4, 'Kuwadzana 4', NULL, 20.00, NULL, 'no', '2022-11-24 05:58:56', '');

-- --------------------------------------------------------

--
-- Table structure for table `types`
--

CREATE TABLE `types` (
  `id` int(11) NOT NULL,
  `types` varchar(255) NOT NULL,
  `created_at` varchar(10) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `types`
--

INSERT INTO `types` (`id`, `types`, `created_at`) VALUES
(4, 'style-style', '2022-07-14'),
(5, 'gender', '2022-07-14'),
(6, 'size', '2022-07-14'),
(7, 'colour', '2022-07-14');

-- --------------------------------------------------------

--
-- Table structure for table `uniformitem`
--

CREATE TABLE `uniformitem` (
  `id` int(11) NOT NULL,
  `studentid` varchar(200) NOT NULL,
  `itemcode` varchar(200) NOT NULL,
  `itemdescript` varchar(200) NOT NULL,
  `itemgroups` varchar(200) NOT NULL,
  `warehouse` varchar(255) NOT NULL,
  `costprice` varchar(200) NOT NULL,
  `sellingprice` varchar(200) NOT NULL,
  `quantity` varchar(200) NOT NULL,
  `originalqnty` varchar(100) NOT NULL,
  `groupsize` varchar(200) NOT NULL,
  `valuesize` varchar(200) NOT NULL,
  `groupstyle` varchar(200) NOT NULL,
  `stylevalue` varchar(200) NOT NULL,
  `colourgroup` varchar(200) NOT NULL,
  `colourvalue` varchar(200) NOT NULL,
  `gendergroup` varchar(200) NOT NULL,
  `gendervalue` varchar(200) NOT NULL,
  `created_at` varchar(200) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `uniformitem`
--

INSERT INTO `uniformitem` (`id`, `studentid`, `itemcode`, `itemdescript`, `itemgroups`, `warehouse`, `costprice`, `sellingprice`, `quantity`, `originalqnty`, `groupsize`, `valuesize`, `groupstyle`, `stylevalue`, `colourgroup`, `colourvalue`, `gendergroup`, `gendervalue`, `created_at`) VALUES
(1, '', 'oo', 'ooo', 'shirts', 'shop1', '20', '25', '5', '10', 'shirts', '14', 'shirts', 'striped', 'shirts', 'blue', 'shirts', 'lll', '2022-07-10'),
(2, '', 'grade1', 'shirt', 'shirts', 'shop1', '20', '25', '25', '25', 'shirts', '11', 'Shirt Style', 'Long Sleeved', 'shirts', 'L/S White', 'shirts', 'Boys', '2022-07-14'),
(3, '', 'SH-11-SS-BLUE', 'shirt size 11-short sleeve-blue', 'select', 'tuckshop', '10', '20', '48', '50', 'Shirt size', '11', 'Shirt style', 'ss', 'Shirt color', 'blue', 'Shirt gender', 'boy', '2022-11-24');

-- --------------------------------------------------------

--
-- Table structure for table `uniformpos`
--

CREATE TABLE `uniformpos` (
  `id` int(11) NOT NULL,
  `student_id` varchar(255) NOT NULL,
  `itemcode` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `quantity` int(255) NOT NULL,
  `amount` varchar(255) NOT NULL,
  `payment` varchar(255) NOT NULL,
  `created_date` varchar(255) NOT NULL,
  `balance` varchar(255) NOT NULL,
  `negativequantity` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `uniformpos`
--

INSERT INTO `uniformpos` (`id`, `student_id`, `itemcode`, `description`, `quantity`, `amount`, `payment`, `created_date`, `balance`, `negativequantity`) VALUES
(16, 'LEA001', 'SH-11-SS-BLUE', 'shirt-size 11-short sleeve-blue', 2, '40', 'USD', '2022-11-24', '-20', 0);

-- --------------------------------------------------------

--
-- Table structure for table `uniform_group`
--

CREATE TABLE `uniform_group` (
  `id` int(11) NOT NULL,
  `groups` varchar(200) NOT NULL,
  `group_type` varchar(400) NOT NULL,
  `is_active` varchar(200) NOT NULL,
  `created_at` varchar(200) NOT NULL,
  `uploaded_at` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `uniform_group`
--

INSERT INTO `uniform_group` (`id`, `groups`, `group_type`, `is_active`, `created_at`, `uploaded_at`) VALUES
(12, 'Shirt style', 'style-style', '', '2022-11-24', 0),
(13, 'Shirt color', 'colour', '', '2022-11-24', 0),
(14, 'Shirt gender', 'gender', '', '2022-11-24', 0),
(15, 'Shirt size', 'size', '', '2022-11-24', 0);

-- --------------------------------------------------------

--
-- Table structure for table `uniform_values`
--

CREATE TABLE `uniform_values` (
  `id` int(11) NOT NULL,
  `values` varchar(200) NOT NULL,
  `description` varchar(200) NOT NULL,
  `groups` varchar(200) NOT NULL,
  `created_at` varchar(200) NOT NULL,
  `is_active` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `uniform_values`
--

INSERT INTO `uniform_values` (`id`, `values`, `description`, `groups`, `created_at`, `is_active`) VALUES
(6, '11', 'size 11', 'Shirt size', '2022-11-24', 0),
(7, 'blue', 'Shirt colour', 'Shirt color', '2022-11-24', 0),
(8, 'boy', 'Shirt gender', 'Shirt gender', '2022-11-24', 0),
(9, 'ss', 'shirt style', 'Shirt style', '2022-11-24', 0);

-- --------------------------------------------------------

--
-- Table structure for table `userlog`
--

CREATE TABLE `userlog` (
  `id` int(11) NOT NULL,
  `user` varchar(100) DEFAULT NULL,
  `role` varchar(100) DEFAULT NULL,
  `ipaddress` varchar(100) DEFAULT NULL,
  `user_agent` varchar(500) DEFAULT NULL,
  `login_datetime` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `userlog`
--

INSERT INTO `userlog` (`id`, `user`, `role`, `ipaddress`, `user_agent`, `login_datetime`) VALUES
(1, 'superadmin@gmail.com', 'Super Admin', '127.0.0.1', 'Firefox 108.0, Windows 10', '2023-01-10 09:17:20'),
(216, 'superadmin@gmail.com', 'Super Admin', '127.0.0.1', 'Firefox 107.0, Windows 10', '2022-11-24 06:47:21'),
(217, 'superadmin@gmail.com', 'Super Admin', '127.0.0.1', 'Firefox 107.0, Windows 10', '2022-11-24 10:56:27'),
(218, 'superadmin@gmail.com', 'Super Admin', '127.0.0.1', 'Firefox 107.0, Windows 10', '2022-11-24 19:46:50'),
(219, 'superadmin@gmail.com', 'Super Admin', '127.0.0.1', 'Firefox 107.0, Windows 10', '2022-11-24 21:47:47'),
(220, 'superadmin@gmail.com', 'Super Admin', '127.0.0.1', 'Firefox 107.0, Windows 10', '2022-11-25 07:16:27'),
(221, 'superadmin@gmail.com', 'Super Admin', '127.0.0.1', 'Firefox 107.0, Windows 10', '2022-11-25 12:08:59');

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `id` int(11) NOT NULL,
  `user_id` int(10) NOT NULL,
  `username` varchar(50) DEFAULT NULL,
  `password` varchar(50) DEFAULT NULL,
  `childs` text NOT NULL,
  `role` varchar(30) NOT NULL,
  `verification_code` varchar(200) NOT NULL,
  `is_active` varchar(255) DEFAULT 'yes',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `users`
--

INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES
(1, 1, 'std1', 'ekxmgt', '', 'student', '', 'yes', '2022-07-14 11:09:32', '0000-00-00 00:00:00'),
(2, 0, 'parent1', 'ph601n', '1', 'parent', '', 'yes', '2022-07-14 11:09:32', '0000-00-00 00:00:00'),
(3, 2, 'std2', 'o1e29q', '', 'student', '', 'yes', '2022-09-21 05:23:34', ''),
(4, 0, 'parent2', '167lj4', '2', 'parent', '', 'yes', '2022-09-21 05:23:34', ''),
(5, 3, 'std3', '4gwfdd', '', 'student', '', 'yes', '2022-11-24 04:38:40', ''),
(6, 0, 'parent3', 'mr4xw6', '3', 'parent', '', 'yes', '2022-11-24 04:38:40', ''),
(7, 0, 'std0', '345igo', '', 'student', '', 'yes', '2023-01-10 09:17:50', '');

-- --------------------------------------------------------

--
-- Table structure for table `users_authentication`
--

CREATE TABLE `users_authentication` (
  `id` int(11) NOT NULL,
  `users_id` int(11) NOT NULL,
  `token` varchar(255) NOT NULL,
  `expired_at` datetime NOT NULL DEFAULT current_timestamp(),
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `vehicles`
--

CREATE TABLE `vehicles` (
  `id` int(10) UNSIGNED NOT NULL,
  `vehicle_no` varchar(20) DEFAULT NULL,
  `vehicle_model` varchar(100) NOT NULL DEFAULT 'None',
  `manufacture_year` varchar(4) DEFAULT NULL,
  `driver_name` varchar(50) DEFAULT NULL,
  `driver_licence` varchar(50) NOT NULL DEFAULT 'None',
  `driver_contact` varchar(20) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `vehicles`
--

INSERT INTO `vehicles` (`id`, `vehicle_no`, `vehicle_model`, `manufacture_year`, `driver_name`, `driver_licence`, `driver_contact`, `note`, `created_at`) VALUES
(2, 'H123W', 'Toyota Hiace', '2006', 'Munya', '5eer413', '0776123554', 'Toyota hiace given to munya', '2022-11-24 06:00:18');

-- --------------------------------------------------------

--
-- Table structure for table `vehicle_routes`
--

CREATE TABLE `vehicle_routes` (
  `id` int(11) UNSIGNED NOT NULL,
  `route_id` int(11) DEFAULT NULL,
  `vehicle_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `vehicle_routes`
--

INSERT INTO `vehicle_routes` (`id`, `route_id`, `vehicle_id`, `created_at`) VALUES
(2, 3, 2, '2022-11-24 06:03:21');

-- --------------------------------------------------------

--
-- Table structure for table `visitors_book`
--

CREATE TABLE `visitors_book` (
  `id` int(11) NOT NULL,
  `source` varchar(100) DEFAULT NULL,
  `purpose` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `contact` varchar(12) NOT NULL,
  `id_proof` varchar(50) NOT NULL,
  `no_of_pepple` int(11) NOT NULL,
  `date` date NOT NULL,
  `in_time` varchar(20) NOT NULL,
  `out_time` varchar(20) NOT NULL,
  `note` mediumtext NOT NULL,
  `image` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `visitors_purpose`
--

CREATE TABLE `visitors_purpose` (
  `id` int(11) NOT NULL,
  `visitors_purpose` varchar(100) NOT NULL,
  `description` mediumtext NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `warehouse`
--

CREATE TABLE `warehouse` (
  `id` int(11) NOT NULL,
  `warehouse` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `created_date` varchar(25) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `warehouse`
--

INSERT INTO `warehouse` (`id`, `warehouse`, `description`, `created_date`) VALUES
(1, 'shop1', 'shop', ''),
(3, 'tuckshop', 'tuckshop', '2022-11-24');
